% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{nonpar_trawlest}
\alias{nonpar_trawlest}
\title{Nonparametric estimation of the trawl function}
\usage{
nonpar_trawlest(data, Delta, lag = 100)
}
\arguments{
\item{data}{Data to be used in the trawl function estimation.}

\item{Delta}{Width of the grid on which we observe the data}

\item{lag}{The lag until which the trawl function should be estimated}
}
\value{
ahat Returns the lag-dimensional vector
\eqn{(\hat a(0), \hat a(\Delta), \ldots, \hat a((lag-1) \Delta)).}
Here, \eqn{\hat a(0)} is estimated
based on the realised variance estimator.

a0_alt Returns the alternative estimator of a(0) using
the same methodology as the one used for
t>0. Note that this is not the recommended estimator to use, but can be
used for comparison purposes.
}
\description{
This function implements the nonparametric trawl estimation proposed in
Sauri and Veraart (2022).
}
\details{
Estimation of the trawl function using the methodology proposed in
Sauri and Veraart (2022). Suppose the data is observed on the grid
0, Delta, 2Delta, ..., (n-1)Delta. Given the path contained in data,
the function  returns the lag-dimensional
vector \deqn{(\hat a(0), \hat a(\Delta), \ldots, \hat a((lag-1) \Delta)).}
In the case when lag=n, the n-1 dimensional vector
\deqn{(\hat a(0), \hat a(\Delta), \ldots, \hat a((n-2) \Delta))} is returned.
}
\examples{
\donttest{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 5000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(1726)
#Simulate the trawl process
Poi_data<-ambit::sim_weighted_trawl(my_n, my_delta, "Exp", my_lambda, "Poi", my_v)$path

#Estimate the trawl function
my_lag <- 100+1
PoiEx_trawl <- nonpar_trawlest(Poi_data, my_delta, lag=my_lag)$a_hat

#Plot the estimated trawl function and superimpose the true one
l_seq <- seq(from = 0,to = (my_lag-1), by = 1)
esttrawlfct.data <- base::data.frame(l=l_seq[1:31],
                               value=PoiEx_trawl[1:31])
p1 <- ggplot2::ggplot(esttrawlfct.data, ggplot2::aes(x=l,y=value))+
  ggplot2::geom_point(size=3)+
  ggplot2::geom_function(fun = function(x) acf_Exp(x*my_delta,my_lambda), colour="red", size=1.5)+
  ggplot2::xlab("l")+
  ggplot2::ylab(latex2exp::TeX("$\\\\hat{a}(\\\\cdot)$ for Poisson trawl process"))
p1
}
}
