# tests/testthat/test-basic.R
test_that("Package loads without error", {
  expect_silent(library(alpmixBayes))
})

test_that("Exported functions exist", {
  expect_true(is.function(demo_run))
  expect_true(is.function(alpmixBayes))
})

test_that("Dataset is available", {
  data(ewg, package = "alpmixBayes")
  expect_true(exists("ewg"))
  expect_true(is.list(ewg))
  expect_true(length(ewg) > 0)
})

test_that("demo_run works in different modes", {
  skip_on_cran()
  skip_if_not(exists("ewg", where = asNamespace("alpmixBayes")))

  # Test quiet mode
  result_quiet <- demo_run(verbose = FALSE)
  expect_true(is.list(result_quiet) || is.data.frame(result_quiet))

  # Test verbose mode (may produce messages)
  result_verbose <- demo_run(verbose = TRUE)
  expect_true(is.list(result_verbose) || is.data.frame(result_verbose))
})
