% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{run_models}
\alias{run_models}
\title{Fit binary classification model}
\usage{
run_models(
  .data,
  target,
  positive,
  models = c("logistic", "rpart", "ctree", "randomForest", "ranger", "xgboost", "lasso")
)
}
\arguments{
\item{.data}{A train_df. Train data to fit the model. It also supports tbl_df, 
tbl, and data.frame objects.}

\item{target}{character. Name of target variable.}

\item{positive}{character. Level of positive class of binary classification.}

\item{models}{character. Algorithm types of model to fit. See details. 
default value is c("logistic", "rpart", "ctree", "randomForest", "ranger", "lasso").}
}
\value{
model_df. results of fitted model.
model_df is composed of tbl_df and contains the following variables.:
\itemize{
\item step : character. The current stage in the model fit process. 
The result of calling run_models() is returned as "1.Fitted".
\item model_id : character. Type of fit model.
\item target : character. Name of target variable.
\item is_factor : logical. Indicates whether the target variable is a factor. 
\item positive : character. Level of positive class of binary classification.
\item negative : character. Level of negative class of binary classification. 
\item fitted_model : list. Fitted model object.
}
}
\description{
Fit some representative binary classification models.
}
\details{
Supported models are functions supported by the representative 
model package used in R environment.
The following binary classifications are supported:
\itemize{
\item "logistic" : logistic regression by glm() in stats package.
\item "rpart" : recursive partitioning tree model by rpart() in rpart package.
\item "ctree" : conditional inference tree model by ctree() in party package.
\item "randomForest" : random forest model by randomForest() in 
randomForest package.
\item "ranger" : random forest model by ranger() in ranger package.
\item "xgboost" : XGBoosting model by xgboost() in xgboost package.
\item "lasso" : lasso model by glmnet() in glmnet package.
}

run_models() executes the process in parallel when fitting the model. 
However, it is not supported in MS-Windows operating system and RStudio 
environment.
}
\examples{
library(dplyr)

# Divide the train data set and the test data set.
sb <- rpart::kyphosis \%>\%
  split_by(Kyphosis)

# Extract the train data set from original data set.
train <- sb \%>\%
  extract_set(set = "train")

# Extract the test data set from original data set.
test <- sb \%>\%
  extract_set(set = "test")

# Sampling for unbalanced data set using SMOTE(synthetic minority over-sampling technique).
train <- sb \%>\%
  sampling_target(seed = 1234L, method = "ubSMOTE")

# Cleaning the set.
train <- train \%>\%
  cleanse

# ---------------------------------------------------------------------------
# Starting with the examples below, uncomment them and run them. ------------
# ---------------------------------------------------------------------------

## Run the model fitting.
# result <- run_models(.data = train, target = "Kyphosis", positive = "present")
# result

## Run the several kinds model fitting by dplyr
# train \%>\%
#   run_models(target = "Kyphosis", positive = "present")

}
