% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{compare_performance}
\alias{compare_performance}
\title{Compare model performance}
\usage{
compare_performance(model)
}
\arguments{
\item{model}{A model_df. results of predicted model that created by run_predict().}
}
\value{
list. results of compared model performance.
list has the following components:
\itemize{
\item recommend_model : character. The name of the model that is recommended as the best among the various models.
\item top_count : numeric. The number of best performing performance metrics by model.
\item mean_rank : numeric. Average of ranking individual performance metrics by model.
\item top_metric : list. The name of the performance metric with the best performance on individual performance metrics by model.
}
The performance metrics calculated are as follows.:
\itemize{
\item ZeroOneLoss : Normalized Zero-One Loss(Classification Error Loss).
\item Accuracy : Accuracy.
\item Precision : Precision.
\item Recall : Recall.
\item Specificity : Specificity.
\item F1_Score : F1 Score.
\item LogLoss : Log loss / Cross-Entropy Loss.
\item AUC : Area Under the Receiver Operating Characteristic Curve (ROC AUC).
\item Gini : Gini Coefficient.
\item PRAUC : Area Under the Precision-Recall Curve (PR AUC).
\item LiftAUC : Area Under the Lift Chart.
\item GainAUC : Area Under the Gain Chart.
\item KS_Stat : Kolmogorov-Smirnov Statistic.
}
}
\description{
compare_performance() compares the performance of a model with several model performance metrics.
}
\examples{
\donttest{
library(dplyr)

# Divide the train data set and the test data set.
sb <- rpart::kyphosis \%>\%
  split_by(Kyphosis)

# Extract the train data set from original data set.
train <- sb \%>\%
  extract_set(set = "train")

# Extract the test data set from original data set.
test <- sb \%>\%
  extract_set(set = "test")

# Sampling for unbalanced data set using SMOTE(synthetic minority over-sampling technique).
train <- sb \%>\%
  sampling_target(seed = 1234L, method = "ubSMOTE")

# Cleaning the set.
train <- train \%>\%
  cleanse

# ---------------------------------------------------------------------------
# Starting with the examples below, uncomment them and run them. ------------
# ---------------------------------------------------------------------------

# Run the model fitting.
# result <- run_models(.data = train, target = "Kyphosis", positive = "present")

# Predict the model.
# pred <- run_predict(result, test)

# Compare the model performance
# This code works fine. When using the example code, uncomment it and run it.
# compare_performance(pred)
}

}
