% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_numerical.R
\name{mle_numerical}
\alias{mle_numerical}
\title{This function takes the output of `optim`, `newton_raphson`, or `sim_anneal`
and turns it into an `mle_numerical` (subclass of `mle`) object.}
\usage{
mle_numerical(sol, options = list(), superclasses = NULL)
}
\arguments{
\item{sol}{the output of `optim` or `newton_raphson`}

\item{options}{list, options for things like sigma and FIM}

\item{superclasses}{list, superclasses to add to the `mle_numerical` object}
}
\value{
An object of class \code{mle_numerical} (subclass of \code{mle}).
}
\description{
This function takes the output of `optim`, `newton_raphson`, or `sim_anneal`
and turns it into an `mle_numerical` (subclass of `mle`) object.
}
\examples{
# Fit exponential distribution using optim
set.seed(123)
x <- rexp(100, rate = 2)

# Log-likelihood for exponential distribution
loglik <- function(rate) {
  if (rate <= 0) return(-Inf)
  sum(dexp(x, rate = rate, log = TRUE))
}

# Optimize (maximize by setting fnscale = -1)
result <- optim(
  par = 1,
  fn = loglik,
  method = "Brent",
  lower = 0.01, upper = 10,
  hessian = TRUE,
  control = list(fnscale = -1)
)

# Wrap in mle_numerical
fit <- mle_numerical(result, options = list(nobs = length(x)))
params(fit)
se(fit)
}
