% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareVGA.R
\name{makeVGAPointMap}
\alias{makeVGAPointMap}
\title{Create a PointMap grid, fill it and make the graph}
\usage{
makeVGAPointMap(
  lineStringMap,
  gridSize,
  fillX,
  fillY,
  maxVisibility = NA,
  boundaryGraph = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{lineStringMap}{Map of lines, either a ShapeMap, or an sf lineString map}

\item{gridSize}{Size of the cells}

\item{fillX}{X coordinate of the fill points}

\item{fillY}{Y coordinate of the fill points}

\item{maxVisibility}{Limit how far two cells can be to be connected}

\item{boundaryGraph}{Only create a graph on the boundary cells}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
A new PointMap
}
\description{
This is intended to be a single command to get from the lines to a PointMap
ready for analysis
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
makeVGAPointMap(
  sfMap,
  gridSize = 0.5,
  fillX = 3.01,
  fillY = 6.7,
  maxVisibility = NA,
  boundaryGraph = FALSE,
  verbose = FALSE
)
}
