% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_preference.R
\name{plot_preference}
\alias{plot_preference}
\title{Visualize Preference}
\usage{
plot_preference(
  Y,
  D,
  Z,
  V = NULL,
  A,
  z_compare = 0,
  true.pscore = NULL,
  nuis_funcs = NULL,
  nuis_funcs_ai = NULL,
  l01_seq = 10^seq(-2, 2, length.out = 100),
  alpha = 0.05,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  p.title = NULL,
  legend.position = "none",
  p.label = c("AI-alone preferred", "Human-alone preferred", "Ambiguous")
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{V}{A matrix of pretreatment covariates (numeric matrix). Optional.}

\item{A}{An observed AI recommendation (binary: numeric vector of 0 or 1).}

\item{z_compare}{A compare treatment indicator (numeric). Default 0.}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}. If NULL, the function will compute the nuisance functions using the provided data. Note that \code{V} must be provided if \code{nuis_funcs} is NULL.}

\item{nuis_funcs_ai}{output from \code{\link{compute_nuisance_functions_ai}}}

\item{l01_seq}{A candidate list of ratio of the loss between false positives and false negatives. Default \code{10^seq(-2, 2, length.out = 100)}.}

\item{alpha}{A significance level (numeric). Default 0.05.}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{legend.position}{Position of the legend (character).}

\item{p.label}{A vector of three labels for the annotations (character). Default c("AI-alone preferred", "Human-alone preferred", "Ambiguous").}
}
\value{
A ggplot object.
}
\description{
Compute the difference in risk between AI and human decision makers using AIPW estimators
over a set of loss ratios, and then visualize when we prefer human over AI decision makers.
Generate a plot based on the overall and subgroup-specific results.
}
\examples{
plot_preference(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  z_compare = 0,
  nuis_funcs = nuis_func,
  nuis_funcs_ai = nuis_func_ai,
  true.pscore = rep(0.5, nrow(NCAdata)),
  l01_seq = 10^seq(-2, 2, length.out = 10),
  alpha = 0.05,
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender",
  x.order = c("Overall", "Non-white", "White", "Female", "Male"),
  p.title = NULL, legend.position = "none",
  p.label = c("AI-alone preferred", "Human-alone preferred", "Ambiguous")
)

}
