% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btaNeeded.R
\name{btaNeeded}
\alias{btaNeeded}
\title{Function to compute log rate ratio needed (fixed sample size)}
\usage{
btaNeeded(
  N,
  thta,
  tau,
  lam,
  alp = 0.05,
  pow = 0.8,
  ar = 0.5,
  frailty.type = c("unblind", "blind"),
  lam.type = c("base", "pool"),
  interval = c(log(0.5), log(1))
)
}
\arguments{
\item{N}{Sample size.}

\item{thta}{Variance of frailty parameter. If frailty.type = "blind", assumes thta derives from pooled model; if frailty.type = "unblind" assumes thta is from correctly specified model. Default "unblind".}

\item{tau}{Expected follow-up time.}

\item{lam}{Event rate. If lam.type = "pool", assumes lam is pooled rate; if lam.type = "base", assumes lam is baseline control event rate. Default "base".}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total)}

\item{frailty.type}{Indicates whether frailty variance is based on blinded information ("blind") or unblinded ("unblind"). Default "unblind".}

\item{lam.type}{Indicates whether event rate is based on control rate ("base") or pooled rate ("pool"). Default "base".}

\item{interval}{Initial search interval for bta1.}
}
\value{
The log rate ratio.
}
\description{
Function to compute log rate ratio needed to achieve target power at one-sided Type I control level alp/2. Useful to compute critical value (set pow = 0.5).
}
\details{
This function computes the log rate ratio bta1 as the root of the equation pow(bta1, N, thta_, tau, lam0_, alp, ar) - pow = 0, where thta_ and lam0_ also depend on bta1 if using estimates from blinded analyses.
If frailty.type = "blind": thta_ = thtap2thta(thta, bta1); otherwise if frailty = "unblind": thta_ = thta. If lam.type = "pool" then lam0_ = lam * 2 / (1 + exp(bta1)); otherwise if lam.type = "base": lam0_ = lam.
Function assumes a rate ratio < 1 is favourable to treatment.
}
\examples{

# Based on unblinded estimates
btaNeeded(N = 1000, thta = 2, tau = 1, lam = 1.1, alp = c(0.01, 0.05), pow = c(.5))
exp(btaNeeded(N = 1000, thta = 2, tau = 1, lam = 1.1, alp = c(0.01, 0.05), pow = c(.5)))

# Based on blinded estimates
btaNeeded(N = 1000, thta = 2, tau = 1, lam = 0.7, alp = c(0.01, 0.05), pow = c( .5),
  frailty.type = "bl", lam.type = "po")
exp(btaNeeded(N = 1000, thta = 2, tau = 1, lam = 0.7, alp = c(0.01, 0.05), pow = c( .5),
               frailty.type = "bl", lam.type = "po"))

# Based on blinded estimates
if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
    crossing(
      thta = c(2, 3, 4),
      lam = 1.1,
      pow = c(0.5, 0.8),
      N = c(500, 1000),
      tau = 1
    ) \%>\%
    mutate(
      bta1 = btaNeeded(N = N, thta = thta, tau = tau, lam = lam, alp = alp, pow = pow),
      RR = exp(bta1)
    )
  assumptions \%>\% data.frame()

}

}
