% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-aglm.R
\name{predict.AccurateGLM}
\alias{predict.AccurateGLM}
\title{Make predictions for new data}
\usage{
\method{predict}{AccurateGLM}(
  object,
  newx = NULL,
  s = NULL,
  type = c("link", "response", "coefficients", "nonzero", "class"),
  exact = FALSE,
  newoffset,
  ...
)
}
\arguments{
\item{object}{A model object obtained from \code{aglm()} or \code{cv.aglm()}.}

\item{newx}{A design matrix for new data.
See the description of \code{x} in \link{aglm} for more details.}

\item{s}{Same as in \link[glmnet]{predict.glmnet}.}

\item{type}{Same as in \link[glmnet]{predict.glmnet}.}

\item{exact}{Same as in \link[glmnet]{predict.glmnet}.}

\item{newoffset}{Same as in \link[glmnet]{predict.glmnet}.}

\item{...}{Other arguments are passed directly when calling \code{predict.glmnet()}.}
}
\value{
The returned object depends on \code{type}.
See \link[glmnet]{predict.glmnet} for more details.
}
\description{
Make predictions for new data
}
\examples{

#################### using plot() and predict() ####################

library(MASS) # For Boston
library(aglm)

## Read data
xy <- Boston # xy is a data.frame to be processed.
colnames(xy)[ncol(xy)] <- "y" # Let medv be the objective variable, y.

## Split data into train and test
n <- nrow(xy) # Sample size.
set.seed(2018) # For reproducibility.
test.id <- sample(n, round(n/4)) # ID numbders for test data.
test <- xy[test.id,] # test is the data.frame for testing.
train <- xy[-test.id,] # train is the data.frame for training.
x <- train[-ncol(xy)]
y <- train$y
newx <- test[-ncol(xy)]
y_true <- test$y

## With the result of aglm()
model <- aglm(x, y)
lambda <- 0.1

plot(model, s=lambda, resid=TRUE, add_rug=TRUE,
     verbose=FALSE, layout=c(3, 3))

y_pred <- predict(model, newx=newx, s=lambda)
plot(y_true, y_pred)

## With the result of cv.aglm()
model <- cv.aglm(x, y)
lambda <- model@lambda.min

plot(model, s=lambda, resid=TRUE, add_rug=TRUE,
     verbose=FALSE, layout=c(3, 3))

y_pred <- predict(model, newx=newx, s=lambda)
plot(y_true, y_pred)


}
\references{
Suguru Fujita, Toyoto Tanaka, Kenji Kondo and Hirokazu Iwasawa. (2020)
\emph{AGLM: A Hybrid Modeling Method of GLM and Data Science Techniques}, \cr
\url{https://www.institutdesactuaires.com/global/gene/link.php?doc_id=16273&fg=1} \cr
\emph{Actuarial Colloquium Paris 2020}
}
\author{
\itemize{
\item Kenji Kondo,
\item Kazuhisa Takahashi and Hikari Banno (worked on L-Variable related features)
}
}
