% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint.box}
\alias{constraint.box}
\title{Create a box constraint for a group.}
\usage{
constraint.box(lower, upper, max_iters = 100, tol = 1e-09)
}
\arguments{
\item{lower}{lower bound for each coefficient in the group. If the group has \code{m} variables, this should be a vector of length \code{m}. Values can be \code{-Inf}.}

\item{upper}{upper bound for each coefficient in the group. If the group has \code{m} variables, this should be a vector of length \code{m}. Values can be \code{Inf}.}

\item{max_iters}{maximum number of proximal Newton iterations; default is 100.}

\item{tol}{convergence tolerance for proximal Newton; default is 1e-9.}
}
\value{
Box constraint object.
}
\description{
A box constraint sets upper and lower bounds for coefficients in a model.
This is done per group, and this function is used separately to set the bounds for each group in the model. The constraints are returned as a list, with number of elements the number of groups. List entries can be \code{NULL}, which means no constraints for that group. Currently works with single-response models (so \code{glm.multinomial} and \code{glm.multigaussian} are excluded). Note that for each group for which non-null constraints are provide, a separate call to \code{constraint.box()} must be made (i.e. the constraint object cannot be replicated). See the second example below.
}
\examples{

# Group of length 10, with positivity constraint on all the coefficients.
lower <- rep(0,10)
upper <- rep(Inf,10)
cont <- constraint.box(lower = lower, upper = upper)

# 10 singleton groups, and non-negativity constraints on all parameters.
cont <- lapply(1:10, function(i)constraint.box(lower = 0, upper = Inf))

# Same as above, but non-negativity constraints only on first 5 parameters.
cont <- lapply(1:5, function(i)constraint.box(lower = 0, upper = Inf))
cont <- c(cont, rep(list(NULL), 5)) # rep rule does not apply to NULL

}
\author{
Trevor Hastie and James Yang\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
