% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs_plot.R
\name{aclhs.plot_variogram_comparison}
\alias{aclhs.plot_variogram_comparison}
\title{Plot the Variogram comparison of the acLHS subsamples.}
\usage{
aclhs.plot_variogram_comparison(df, aclhs_samples, vario_params, plot_params)
}
\arguments{
\item{df}{The original dataframe}

\item{aclhs_samples}{The acLHS-derived sample indices}

\item{vario_params}{The parameters to set for computing a Variogram}

\item{plot_params}{The plotting parameters to use}
}
\value{
No return value, called for side effects
}
\description{
Plots the acLHS-sampled Variogram against the Variogram of
the original data. A best-fit curve of the original Variogram
is added for clearer comparison.
}
\examples{
#' ## Get the data of interest and get the acLHS sample indices
data(ex_data_2D)
input2D <- ex_data_2D
v_params <- aclhs.vario_params(num_lags=10, dir=0, tol=90, min_pairs=1)
aclhs_sam <- aclhs(df=input2D, num_samples=50, weights=c(1,1,1),
                   iter=100, vario_params=v_params)

## Set plotting parameters
p_params <- aclhs.plot_params(file_name=tempfile(fileext=".png"),
                              xlab=expression(bold("Distance [km]")),
                              ylab=expression(bold("Semivariance")))

## Create plot
aclhs.plot_variogram_comparison(df=input2D, aclhs_samples=aclhs_sam,
                                vario_params=v_params, plot_params=p_params)
}
