% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_table.R
\name{f_table}
\alias{f_table}
\title{Frequency table for binned data}
\usage{
f_table(x, min_x, max_x, bin_res)
}
\arguments{
\item{x, }{numeric, a vector of binned data}

\item{min_x, }{numeric, the minimal value of x}

\item{max_x, }{numeric, the maximal value of x}

\item{bin_res, }{numeric, the bin resolution}
}
\value{
A data frame
}
\description{
Creates a frequency table from a vector of bins from, for example,
get_bins(). It includes zero-frequency bins. If the bins came from the
responding times, this creates a data.frame of response rate.
}
\examples{
data("r_times")
bin_res <- 2
min_x <- 0
max_x <- 180
x <- get_bins(r_times, min_x, max_x, bin_res)
xt <- f_table(x, min_x, max_x, bin_res)
plot(xt$bins, xt$prop)
}
