% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curv_indexes.R
\name{curv_index_int}
\alias{curv_index_int}
\title{Curvature index by numerical integration}
\usage{
curv_index_int(cr, time_in)
}
\arguments{
\item{cr}{numeric, cumulative response}

\item{time_in}{numeric, time (or the x axis in a cumulative response plot)}
}
\value{
a numeric value that is the proportion of a rect triangle area minus
the area under the curve
}
\description{
Curvature index by numerical integration
}
\examples{
data("r_times")
r_times <- r_times[r_times < 60]
cr <- seq_along(r_times)

plot(r_times, cr, type = "s")
curv_index_int(cr, r_times)
segments(
  x0 = min(r_times), y0 = min(cr),
  x1 = max(r_times), y1 = max(cr)
)
segments(
  x0 = min(r_times) + (max(r_times) - min(r_times)) / 2, y0 = min(cr),
  x1 = max(r_times), y1 = max(cr),
  col = "red"
)
}
