## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## ----mutual-information-example-----------------------------------------------
set.seed(123)
x <- rnorm(1000)
y <- rnorm(1000)
plot(x, y, main = "Independent Variables")
# close to 0 if they are independent
mi_discrete_independent <- mut_info_discrete(x, y)
mi_knn_independent <- mut_info_knn(x, y, k = 2, direct = TRUE)
cat("Mutual Information (Discrete) for independent variables:", mi_discrete_independent, "\n")
cat("Mutual Information (KNN) for independent variables:", mi_knn_independent, "\n")

y <- 100 * x + rnorm(length(x), 0, 12)
plot(x, y, main = "Dependent Variables")
# far from 0 if they are not independent
mi_discrete_dependent <- mut_info_discrete(x, y)
mi_knn_dependent <- mut_info_knn(x, y, k = 2, direct = TRUE)
cat("Mutual Information (Discrete) for dependent variables:", mi_discrete_dependent, "\n")
cat("Mutual Information (KNN) for dependent variables:", mi_knn_dependent, "\n")

# simulate a sine function with noise
set.seed(123)
x <- seq(0, 5, 0.1)
y <- 5 * sin(x * pi)
y_with_noise <- y + rnorm(length(x), 0, 0.5)
plot(x, y_with_noise, main = "Sine Function with Noise")
lines(x, y, col = 2)
# add a regression line
abline(lm(y ~ x))
# compute correlation coefficient; for nonlinear functions is close to 0
correlation <- cor(x, y_with_noise)
cat("Correlation coefficient for sine function with noise:", correlation, "\n")
# mutual information can detect nonlinear dependencies
mi_discrete_sine <- mut_info_discrete(x, y_with_noise)
mi_knn_sine <- mut_info_knn(x, y_with_noise, k = 2, direct = TRUE)
cat("Mutual Information (Discrete) for sine function with noise:", mi_discrete_sine, "\n")
cat("Mutual Information (KNN) for sine function with noise:", mi_knn_sine, "\n")

