% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signal_stable.R
\name{extract_signal_stable}
\alias{extract_signal_stable}
\title{Extract a signal/cycle from a wavelet spectra using a set period and boundaries}
\usage{
extract_signal_stable(
  wavelet = NULL,
  cycle = NULL,
  period_up = 1.2,
  period_down = 0.8,
  add_mean = TRUE,
  plot_residual = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function.}

\item{cycle}{Period of the cycle which needs to be extracted.}

\item{period_up}{Specifies the upper period as a factor of the to be extracted cycle \code{Default=1.2}.}

\item{period_down}{Specifies the lower period as a factor of the to be extracted cycle \code{Default=0.8}.}

\item{add_mean}{Add mean to the extracted cycle \code{Default=TRUE}.}

\item{plot_residual}{plot the residual signal after extraction of set cycle \code{Default=FALSE}.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
#'Returns a matrix with 2 columns.
The first column is time/depth.
The second column is the extracted signal/cycle.
}
\description{
Extracts a cycle from the wavelet object created using the \code{\link{analyze_wavelet}}
function using a fixed period and fixed period boundaries defined as factors of the original cycle
}
\examples{
#Example in which the ~210yr de Vries cycle is extracted from the Total Solar
#Irradiance data set of Steinhilber et al., (2012)

#Perform the CWT
TSI_wt <-
analyze_wavelet(
data = TSI,
dj = 1/200,
lowerPeriod = 16,
upperPeriod = 8192,
   verbose = FALSE,
   omega_nr = 6
 )

#Extract the 210 yr de Vries cycle from the wavelet spectra
de_Vries_cycle <- extract_signal_stable(wavelet=TSI_wt,
cycle=210,
period_up =1.25,
period_down = 0.75,
add_mean=TRUE,
plot_residual=FALSE,
keep_editable=FALSE)

}
\references{
Angi Roesch and Harald Schmidbauer (2018). WaveletComp: Computational
Wavelet Analysis. R package version 1.1.
\url{https://CRAN.R-project.org/package=WaveletComp}

Gouhier TC, Grinsted A, Simko V (2021). R package biwavelet: Conduct Univariate and Bivariate Wavelet Analyses. (Version 0.20.21),
\url{https://github.com/tgouhier/biwavelet}

Torrence, C., and G. P. Compo. 1998. A Practical Guide to Wavelet Analysis.
Bulletin of the American Meteorological Society 79:61-78.
\url{https://paos.colorado.edu/research/wavelets/bams_79_01_0061.pdf}
}
\author{
Code based on the reconstruct function of the 'WaveletComp' R package
which is based on the wavelet 'MATLAB' code written by Christopher Torrence and Gibert P. Compo (1998).
}
