% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warEst.R
\name{WARp_acvfs}
\alias{WARp_acvfs}
\title{Function for calculating sample Wasserstein autocovariance functions}
\usage{
WARp_acvfs(end.day, training.size, quantile, quantile.grid, p)
}
\arguments{
\item{end.day}{A positive integer, the last index of the training window.}

\item{training.size}{A positive integer, the size of the training widnows.}

\item{quantile}{A matrix containing all the available quantile functions. Columns represent time indices and rows represent evaluation grid.}

\item{quantile.grid}{A numeric vector, the grid over which quantile functions are evaluated.}

\item{p}{A positive integer, the maximum order of the sample Wasserstein autocovariance functions.}
}
\value{
A list with
\itemize{
  \item acvfs - The sample Wasserstein autocovariance functions from order \eqn{0} to \eqn{p}
  \item barycenter - The sample average of the quantile functions in the training window
  \item quantile.pred - The quantile functions from \eqn{end.day - p + 1} to \eqn{end.day}
}
}
\description{
This function uses a time series of quantile functions to calculate the sample Wasserstein autocovariance functions from order \eqn{0} to \eqn{p} with a specified training window
}
\keyword{internal}
