% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warEst.R
\name{WARp}
\alias{WARp}
\title{WAR(p) models: estimation and forecast}
\usage{
WARp(quantile, quantile.grid, p)
}
\arguments{
\item{quantile}{A matrix containing all the sample quantile functions. Columns represent time indices and rows represent evaluation grid.}

\item{quantile.grid}{A numeric vector, the grid over which quantile functions are evaluated.}

\item{p}{A positive integer, the order of the fitted WAR(p) model.}
}
\value{
A \code{WARp} object of:
\item{coef}{estimated AR parameters of the fitted WAR(p) model}
\item{coef.cov}{covariance matrix of \code{coef}}
\item{acvf}{Wasserstein autocovariance function values}
\item{Wass.mean}{Wasserstein mean quantile function}
\item{quantile}{a matrix containing all the sample quantile functions (columns represent time indices and rows represent evaluation grid)}
\item{quantile.grid}{quantile function grid that is utilized in calculation}
\item{order}{a positive integer, the order of the fitted WAR(p) model}
}
\description{
this function produces an object of the WARp class which includes WAR(p) model parameter estimates and relevant quantities (see output list)
}
\details{
This function takes in a density time series in the form of the corresponding quantile functions as the main input. If the quantile series is not readily available, a general practice is to estimate density functions from samples, then use \code{dens2quantile} from the \code{fdadensity} package to convert density time series to quantile series.
}
\examples{
# Simulate a density time series represented in quantile functions
# warSimData$sample.ts: A sample TS of quantile functions of length 100, taken from
#            the simulation experiments in Section 4 of Zhang et al. 2022.

# warSimData$quantile.grid: The grid over which quantile functions in sample.ts are evaluated.

warSimData <- warSim()

p <- 3
dSup <- seq(-2, 2, 0.02)
expSup <- seq(-2, 2, 0.1)

# Estimation: fit a WAR(3) model
WARp_obj <- WARp(warSimData$sample.ts, warSimData$quantile.grid, p)

# Forecast: one-step-ahead forecast
forecast_1 <- predict(WARp_obj)               # dSup and expSup are chosen automatically
forecast_2 <- predict(WARp_obj, dSup, expSup) # dSup and expSup are chosen by user

# Plots
par(mfrow=c(1,2))

plot(forecast_1$dSup, forecast_1$pred.cdf, type="l", xlab="dSup", ylab="cdf")
plot(forecast_1$dSup, forecast_1$pred.pdf, type="l", xlab="dSup", ylab="pdf")

plot(forecast_2$dSup, forecast_2$pred.cdf, type="l", xlab="dSup", ylab="cdf")
plot(forecast_2$dSup, forecast_2$pred.pdf, type="l", xlab="dSup", ylab="pdf")


}
\references{
\cite{Wasserstein Autoregressive Models for Density Time Series, Chao Zhang, Piotr Kokoszka, Alexander Petersen, 2022}
}
