% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plot.WH_1d}
\alias{plot.WH_1d}
\title{Plot 1D WH fit}
\usage{
\method{plot}{WH_1d}(x, what = "fit", trans, ...)
}
\arguments{
\item{x}{An object of class \code{"WH_1d"} returned by the \code{\link[=WH]{WH()}} function}

\item{what}{What should be plotted. Should be one of \code{fit} (the
default), \code{res} for residuals and \code{edf} for the effective degrees
of freedom.}

\item{trans}{An (optional) transformation to be applied to the data. By
default the identity function}

\item{...}{Not used}
}
\value{
A plot representing the desired element of the fit
}
\description{
Plot 1D WH fit
}
\examples{
d <- portfolio_mort$d
ec <- portfolio_mort$ec

WH(d, ec) |> plot()
WH(d, ec) |> plot("res")
WH(d, ec) |> plot("edf")

}
