% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{Relationship}
\alias{Relationship}
\title{Relationship}
\description{
A relationship between entities
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Unique identifier}

\item{\code{source_id}}{Source entity ID}

\item{\code{target_id}}{Target entity ID}

\item{\code{type}}{Relationship type}

\item{\code{description}}{Description}

\item{\code{weight}}{Relationship weight}

\item{\code{source_chunks}}{Source chunk IDs}

\item{\code{metadata}}{Additional metadata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Relationship-new}{\code{Relationship$new()}}
\item \href{#method-Relationship-to_list}{\code{Relationship$to_list()}}
\item \href{#method-Relationship-clone}{\code{Relationship$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Relationship-new"></a>}}
\if{latex}{\out{\hypertarget{method-Relationship-new}{}}}
\subsection{Method \code{new()}}{
Create a new Relationship
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Relationship$new(
  source_id,
  target_id,
  type,
  description = NULL,
  weight = 1,
  source_chunks = NULL,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source_id}}{Source entity}

\item{\code{target_id}}{Target entity}

\item{\code{type}}{Relationship type}

\item{\code{description}}{Description}

\item{\code{weight}}{Weight}

\item{\code{source_chunks}}{Sources}

\item{\code{metadata}}{Metadata}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Relationship-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-Relationship-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert to list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Relationship$to_list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Relationship-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Relationship-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Relationship$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
