% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reranker.R
\name{MMRReranker}
\alias{MMRReranker}
\title{Maximal Marginal Relevance (MMR) Reranker}
\description{
Reranks for diversity using MMR algorithm
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lambda}}{Balance between relevance and diversity (0-1)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MMRReranker-new}{\code{MMRReranker$new()}}
\item \href{#method-MMRReranker-rerank}{\code{MMRReranker$rerank()}}
\item \href{#method-MMRReranker-clone}{\code{MMRReranker$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MMRReranker-new"></a>}}
\if{latex}{\out{\hypertarget{method-MMRReranker-new}{}}}
\subsection{Method \code{new()}}{
Create a new MMRReranker
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MMRReranker$new(lambda = 0.7)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lambda}}{Relevance vs diversity tradeoff (higher = more relevance)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MMRReranker-rerank"></a>}}
\if{latex}{\out{\hypertarget{method-MMRReranker-rerank}{}}}
\subsection{Method \code{rerank()}}{
Rerank for diversity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MMRReranker$rerank(query_vector, doc_vectors, doc_ids, scores, limit = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_vector}}{Query embedding}

\item{\code{doc_vectors}}{Matrix of document embeddings}

\item{\code{doc_ids}}{Vector of document IDs}

\item{\code{scores}}{Original relevance scores}

\item{\code{limit}}{Number of results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with reranked results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MMRReranker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MMRReranker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MMRReranker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
