% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{CommunityDetector}
\alias{CommunityDetector}
\title{Simple Community Detector}
\description{
Detects communities using connected components
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{min_size}}{Minimum community size}

\item{\code{max_levels}}{Maximum hierarchy levels}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CommunityDetector-new}{\code{CommunityDetector$new()}}
\item \href{#method-CommunityDetector-detect}{\code{CommunityDetector$detect()}}
\item \href{#method-CommunityDetector-clone}{\code{CommunityDetector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommunityDetector-new"></a>}}
\if{latex}{\out{\hypertarget{method-CommunityDetector-new}{}}}
\subsection{Method \code{new()}}{
Create a new CommunityDetector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommunityDetector$new(min_size = 5, max_levels = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_size}}{Min size}

\item{\code{max_levels}}{Max levels}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommunityDetector-detect"></a>}}
\if{latex}{\out{\hypertarget{method-CommunityDetector-detect}{}}}
\subsection{Method \code{detect()}}{
Detect communities in graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommunityDetector$detect(graph)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graph}}{KnowledgeGraph object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of Community objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommunityDetector-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CommunityDetector-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommunityDetector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
