% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{Collection}
\alias{Collection}
\title{Collection Class}
\description{
Vector collection with indexing and search
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Collection name}

\item{\code{dimension}}{Vector dimension}

\item{\code{metric}}{Distance metric}

\item{\code{language}}{Language setting ("en" or "ml")}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Collection-new}{\code{Collection$new()}}
\item \href{#method-Collection-add}{\code{Collection$add()}}
\item \href{#method-Collection-search}{\code{Collection$search()}}
\item \href{#method-Collection-keyword_search}{\code{Collection$keyword_search()}}
\item \href{#method-Collection-hybrid_search}{\code{Collection$hybrid_search()}}
\item \href{#method-Collection-get}{\code{Collection$get()}}
\item \href{#method-Collection-delete}{\code{Collection$delete()}}
\item \href{#method-Collection-count}{\code{Collection$count()}}
\item \href{#method-Collection-clear}{\code{Collection$clear()}}
\item \href{#method-Collection-clone}{\code{Collection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-new}{}}}
\subsection{Method \code{new()}}{
Create a new Collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$new(
  name,
  dimension,
  metric = "cosine",
  storage = NULL,
  language = "en"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}

\item{\code{dimension}}{Vector dimension}

\item{\code{metric}}{Distance metric}

\item{\code{storage}}{Storage backend}

\item{\code{language}}{Language behavior ("en" = ASCII-focused, "ml" = Unicode-aware)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-add"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-add}{}}}
\subsection{Method \code{add()}}{
Add documents to collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$add(ids, vectors, metadata = NULL, texts = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Document IDs}

\item{\code{vectors}}{Matrix of vectors}

\item{\code{metadata}}{List of metadata}

\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-search"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-search}{}}}
\subsection{Method \code{search()}}{
Search collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$search(query, limit = 10, filter = NULL, include_vectors = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query vector}

\item{\code{limit}}{Number of results}

\item{\code{filter}}{Metadata filter}

\item{\code{include_vectors}}{Include vectors in results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Results object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-keyword_search"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-keyword_search}{}}}
\subsection{Method \code{keyword_search()}}{
Keyword search
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$keyword_search(query_text, limit = 10, filter = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_text}}{Query text}

\item{\code{limit}}{Number of results}

\item{\code{filter}}{Metadata filter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Results object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-hybrid_search"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-hybrid_search}{}}}
\subsection{Method \code{hybrid_search()}}{
Hybrid search (dense + sparse)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$hybrid_search(
  query,
  query_text,
  limit = 10,
  vector_weight = 0.5,
  text_weight = 0.5,
  filter = NULL,
  include_vectors = FALSE,
  rrf_k = 60,
  prefetch_multiplier = 10
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query vector}

\item{\code{query_text}}{Query text}

\item{\code{limit}}{Number of results}

\item{\code{vector_weight}}{Weight for vector search}

\item{\code{text_weight}}{Weight for text search}

\item{\code{filter}}{Metadata filter}

\item{\code{include_vectors}}{Include vectors in results}

\item{\code{rrf_k}}{RRF constant}

\item{\code{prefetch_multiplier}}{Prefetch multiplier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Results object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-get"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-get}{}}}
\subsection{Method \code{get()}}{
Get documents by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$get(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Document IDs}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-delete}{}}}
\subsection{Method \code{delete()}}{
Delete documents by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$delete(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Document IDs to delete}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-count"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-count}{}}}
\subsection{Method \code{count()}}{
Get document count
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$count()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-clear}{}}}
\subsection{Method \code{clear()}}{
Clear collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
