% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generator.R
\name{data_generator_vd}
\alias{data_generator_vd}
\title{Data generator function for the variable domain case}
\usage{
data_generator_vd(
  N = 100,
  J = 100,
  nsims = 1,
  Rsq = 0.95,
  aligned = TRUE,
  multivariate = FALSE,
  beta_index = 1,
  use_x = FALSE,
  use_f = FALSE
)
}
\arguments{
\item{N}{Number of subjects.}

\item{J}{Number of maximum observations per subject.}

\item{nsims}{Number of simulations per the simulation study.}

\item{Rsq}{Variance of the model.}

\item{aligned}{If the data that will be generated is aligned or not.}

\item{multivariate}{If TRUE, the data is generated with 2 functional variables.}

\item{beta_index}{Index for the beta.}

\item{use_x}{If the data is generated with x.}

\item{use_f}{If the data is generated with f.}
}
\value{
A list containing the following components:
\itemize{
\item y: \code{vector} of length N containing the response variable.
\item X_s: \code{matrix} of non-noisy functional data for the first functional covariate.
\item X_se: \code{matrix} of noisy functional data for the first functional covariate
\item Y_s: \code{matrix} of non-noisy functional data for the second functional covariate (if multivariate).
\item Y_se: \code{matrix} of noisy functional data for the second covariate (if multivariate).
\item x1: \code{vector} of length N containing the non-functional covariate (if use_x is TRUE).
\item x2: \code{vector} of length N containing the observed values of the smooth term (if use_f is TRUE).
\item smooth_term: \code{vector} of length N containing a smooth term (if use_f is TRUE).
\item Beta: \code{array} containing the true functional coefficients.
}
}
\description{
Generates a variable domain functional regression model
}
\examples{
# Basic usage with default parameters
sim_data <- data_generator_vd()

# Generate data with non-aligned domains
non_aligned_data <- data_generator_vd(N = 150, J = 120, aligned = FALSE)

# Generate multivariate functional data
multivariate_data <- data_generator_vd(N = 200, J = 100, multivariate = TRUE)

# Generate data with non-functional covariates and smooth term
complex_data <- data_generator_vd(
  N = 100,
  J = 150,
  use_x = TRUE,
  use_f = TRUE
)

# Generate data with a different beta function and R-squared value
custom_beta_data <- data_generator_vd(
  N = 80,
  J = 80,
  beta_index = 2,
  Rsq = 0.8
)

# Access components of the generated data
y <- sim_data$y # Response variable
X_s <- sim_data$X_s # Noise-free functional covariate
X_se <- sim_data$X_se # Noisy functional covariate

}
