% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phi.varshrinkest.R
\name{Phi.varshrinkest}
\alias{Phi.varshrinkest}
\title{Coefficient matrices of the MA represention}
\usage{
\method{Phi}{varshrinkest}(x, nstep = 10, ...)
}
\arguments{
\item{x}{An object of class "varshrinkest",
generated by \code{VARshrink()}.}

\item{nstep}{An integer specifying the number of moving error
coefficient matrices to be calculated.}

\item{...}{Currently not used.}
}
\value{
An array with dimension \eqn{K \times K \times (nstep + 1)} holding
the estimated coefficients of the moving average representation. The first
slice of the array is the starting value, i.e., \eqn{\mathbf{\Phi}_0}.
}
\description{
Returns the estimated coefficient matrices of the moving average
representation of a stable VAR(p).
}
\details{
This is a modification of \code{vars::Phi.varest()} for the class
"varshrinkest", preventing redundant copying of data matrix objects.
}
\seealso{
\code{\link[vars]{Phi}}
}
