% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bcoef_sh.R
\name{Bcoef_sh}
\alias{Bcoef_sh}
\title{Coefficient matrix of an estimated VAR(p)}
\usage{
Bcoef_sh(x)
}
\arguments{
\item{x}{An object of class "varshrinkest" generated by \code{VARshrink()}.}
}
\value{
A matrix holding the estimated coefficients of a VAR.
}
\description{
Returns the estimated coefficients of a VAR(p) model as a matrix.
}
\details{
Consider VAR(p) model:
\deqn{\mathbf{y}_t = \mathbf{A}_1 \mathbf{y}_{t-1} + ... + \mathbf{A}_p
\mathbf{y}_{t-p} + \mathbf{C} \mathbf{d}_t + \mathbf{e}_t.}
The function returns the concatenated matrix \eqn{(\mathbf{A}_1, ...,
\mathbf{A}_p, \mathbf{C})} as a matrix object.

This function modifies \code{vars::Bcoef()} for the class "varshrinkest",
preventing redundant copying of data matrix objects.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
Bcoef_sh(estim)
}
\seealso{
\code{\link[vars]{Bcoef}}
}
