% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{transformData}
\alias{transformData}
\title{Transform Data for VAR Estimation}
\usage{
transformData(data, p, opt)
}
\arguments{
\item{data}{A numeric matrix or data frame with time series data (observations in rows,
variables in columns).}

\item{p}{Integer. The order of the VAR model (number of lags).}

\item{opt}{List. Options for data transformation. Supported options include:
\itemize{
\item \code{scale}: Logical. Whether to scale the data columns (default is \code{FALSE}).
\item \code{center}: Logical. Whether to center the data columns (default is \code{TRUE}).
}}
}
\value{
A list with the following components:
\item{X}{The design matrix (via the Kronecker product) for lagged predictors.}
\item{y}{A vectorized response corresponding to the lagged data.}
\item{series}{The (centered and possibly scaled) original time series matrix.}
\item{mu}{A row vector of the column means used for centering.}
}
\description{
Transforms the input time series data into the design matrices required for VAR estimation.
This includes centering, optional scaling, and constructing the lagged predictor matrix.
}
\keyword{internal}
