# upsilon.statistic.R
#
# Author: Xuye Luo, Joe Song
# 
# Updated:
#
# December 20, 2025
#   Updated documentation
#
# December 12, 2025

#' @importFrom Rcpp sourceCpp
#' @useDynLib Upsilon, .registration=TRUE

#' @title Upsilon Test Statistic for Contingency Tables
#' @description
#' Calculates the Upsilon test statistic \eqn{\Upsilon}.
#' 
#' @inherit upsilon.test details
#' @param x a matrix or data frame of floating or integer
#'  numbers to specify a contingency table. Entries
#'  must be non-negative.
#'
#' @return The numeric value of Upsilon test statistic \eqn{\Upsilon}.
#' 
#' @references
#' \insertRef{luo2021upsilon}{Upsilon}
#' 
#' @export
#'
#' @examples
#' library("Upsilon")
#' 
#' # Create a contingency table
#' x <- matrix(c(
#'     0, 3, 0, 
#'     3, 0, 0), 
#'   nrow = 2, byrow = TRUE)
#' print(x)
#' 
#' # Calculate statistic
#' upsilon.statistic(x)
#' @keywords internal
upsilon.statistic <- function(x) {
  
  x <- as.matrix(x)
  
  # Input Validation
  if (!is.numeric(x)) {
    stop("Input 'x' must be a numeric matrix or contingency table.")
  }
  if (any(x < 0, na.rm = TRUE)) {
    stop("Observed counts 'x' must be non-negative.")
  }
  
  # Call C++ backend
  statistic <- upsilon_statistic_cpp(x)
  
  return(statistic)
}