% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_uve.R
\name{annual_uve}
\alias{annual_uve}
\title{Annual erythemal UV}
\usage{
annual_uve(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  type = "cumulative",
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdec}. Default is current directory.}

\item{type}{Type of annual dose to be calculated, cumulative (default) or mean.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of mean or cumulative annual erythemal UV dose estimates.
}
\description{
This function extracts mean or cumulative erythemal UV dose  at a given date and geographical location (longitude and latitude), over one year prior to the index date.
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uve_example <- system.file("extdata", "uve_example", package="UVdose")
annual_uve(mysample, date, longitude, latitude, temis_path=uve_example)

}
