% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_uvb.R
\name{annual_uvb}
\alias{annual_uvb}
\title{Annual UVB}
\usage{
annual_uvb(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  type = "cumulative",
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{date vector, usually date of assessment or recruitment.}

\item{longitude}{numeric vector of longitude values.}

\item{latitude}{numeric vector of latitude values.}

\item{temis_path}{path to TEMIS UV files downloaded using \link{temis_uvdvc}. Default is current directory.}

\item{type}{Type of annual dose to be calculated, cumulative (default) or mean.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of mean or cumulative annual vitamin D UVB dose estimates.
}
\description{
This function extracts vitamin D-effective UVB dose (i.e. UVB wavelenghts that can induce vitamin D synthesis in human skin) on a particular date and geographical location (longitude and latitude), over one year prior to the index date.
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uvb_example <- system.file("extdata", "uvb_example", package="UVdose")
annual_uvb(mysample, date, longitude, latitude, temis_path=uvb_example)

}
