% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean_}
\alias{mean_}
\title{Statistical Mean Function}
\usage{
mean_(x = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional numeric vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The arithmetic mean of the vector
}
\description{
This function calculates the arithmetic mean of a numeric vector.
Can be used in three modes: simple calculation, learning mode with step-by-step
explanation, or interactive mode for practice.
}
\examples{
# Simple calculation
data <- c(1,2,2,5,10,4,2)
mean_(data)

# Learning mode
mean_(data, learn = TRUE)

# Interactive mode
if(interactive()){
mean_(interactive = TRUE)
}

}
