% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLAM_2d_covariates.R
\name{GLAM_2d_covariates}
\alias{GLAM_2d_covariates}
\title{Fit the 2d GLAM with covariates}
\usage{
GLAM_2d_covariates(
  R,
  Y,
  Bu,
  Bs,
  Z,
  Wprior = NULL,
  P,
  ridge = 0,
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE)
)
}
\arguments{
\item{R}{A 3d-array of dimensions nu by ns by n containing exposure times.}

\item{Y}{A 3d-array of dimensions nu by ns by n containing event indicators.}

\item{Bu}{A matrix of B-splines for the \code{u} time scale of dimension nu by cu.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{Z}{(optional) A regression matrix of covariates values of dimensions
n by p.}

\item{Wprior}{An optional matrix of a-priori weights.}

\item{P}{The penalty matrix of dimension cucs by cucs.}

\item{ridge}{A ridge penalty parameter: default is 0.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
}}
}
\value{
A list with the following elements:
\itemize{
\item \code{Alpha} The matrix of estimated P-splines coefficients of dimension
cu by cs.
\item \code{Cov_alpha} The variance-covariance matrix of the \code{Alpha} coefficients,
of dimension cucs by cucs.
\item \code{beta} The vector of length p of estimated covariates coefficients.
\item \code{Cov_beta} The variance-covariance matrix of the \code{beta} coefficients,
of dimension p by p.
\item \code{SE_beta} The vector of length p of estimated Standard Errors for the \code{beta}
coefficients.
\item \code{Eta0} The matrix of values of the baseline linear predictor (log-hazard)
of dimension nu by ns.
\item \code{H} The hat-matrix.
\item \code{deviance} The deviance.
\item \code{ed} The effective dimension of the model.
\item \code{aic} The value of the AIC.
\item \code{bic} The value of the BIC.
\item \code{Bbases} a list with the B-spline bases \code{Bu} and \code{Bs}.
}
}
\description{
\code{GLAM_2d_covariates()} fits a GLAM for the hazard with two time
scales, with covariates.
}
