% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_datastore_duckdb.R
\name{save_to_duckdb}
\alias{save_to_duckdb}
\title{Save expanded data to \code{DuckDB}}
\usage{
save_to_duckdb(path)
}
\arguments{
\item{path}{Directory to save \code{DuckDB} database file in.}
}
\value{
A \linkS4class{te_datastore_duckdb} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
if (require(duckdb)) {
  duckdb_dir <- file.path(tempdir(), "expanded_trials_duckdb")

  trial_to_expand <- trial_sequence("ITT") |>
    set_data(data = data_censored) |>
    set_expansion_options(output = save_to_duckdb(path = duckdb_dir), chunk_size = 500)

  # Delete directory after use
  unlink(duckdb_dir)
}

}
\seealso{
Other save_to: 
\code{\link{save_to_csv}()},
\code{\link{save_to_datatable}()},
\code{\link{set_expansion_options}()}
}
\concept{save_to}
