% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_curves.R
\name{filter_curves}
\alias{filter_curves}
\title{Filter, detrend, and quality-control luminescence time-series data}
\usage{
filter_curves(
  x,
  time,
  meta = NULL,
  from = min(time, na.rm = TRUE),
  to = max(time, na.rm = TRUE),
  min_lum = 0,
  periodogram_length = NULL
)
}
\arguments{
\item{x}{A numeric matrix of luminescence values, where rows correspond to
time points and columns correspond to samples. Sparse matrices are allowed.}

\item{time}{A numeric vector giving the time points corresponding to the rows
of \code{x}.}

\item{meta}{An optional data frame containing sample metadata. Must include
a \code{Sample_id} column and may include a \code{Genotype} column.}

\item{from}{Numeric value specifying the start time for analysis. Defaults
to the minimum of \code{time}.}

\item{to}{Numeric value specifying the end time for analysis. Defaults to
the maximum of \code{time}.}

\item{min_lum}{Numeric threshold specifying the minimum luminescence value
required for a sample to be retained. Samples with a minimum value less
than or equal to this threshold are removed. Default is 0.}

\item{periodogram_length}{Numeric value specifying the length (in the same
units as \code{time}) of the time window used for Lomb–Scargle periodogram
analysis. If \code{NULL}, the full selected time range is used.}
}
\value{
A list with the following elements:
\describe{
  \item{curves}{A data frame containing the time vector and detrended
    luminescence curves that passed all filtering steps.}
  \item{meta_kept}{A data frame of metadata corresponding to retained samples,
    or \code{NULL} if no metadata were supplied.}
  \item{removed}{A data frame logging samples removed during filtering and
    the reason for removal, or \code{NULL} if no samples were removed.}
}
}
\description{
\code{filter_curves} preprocesses luminescence time-series data by applying
a series of quality control and rhythm-detection steps. The function first
subsets the data to a specified time window, removes samples with low signal
intensity, detrends each time series using linear regression, and then
assesses rhythmicity using Lomb–Scargle periodogram analysis. Only samples
showing statistically significant rhythmic components are retained.
}
\details{
The function returns detrended curves that pass all filtering criteria,
along with optional metadata for retained samples and a log of samples
removed at each step.


After subsetting the data to the requested time window, samples are filtered
based on minimum luminescence to remove low-signal or failed measurements.
Each remaining time series is detrended by fitting a linear model against
time and extracting residuals. Rhythmicity is then assessed using a
Lomb–Scargle periodogram over periods between 18 and 30 hours. Samples whose
strongest spectral peak does not exceed the corresponding significance
threshold are classified as non-rhythmic and removed.

A record of all removed samples and the reason for their removal is returned
to support transparent quality control.
}
\examples{
data(mydata_example)
data <- mydata_example[, -1]
time <- as.numeric(mydata_example[, 1])

res <- filter_curves(
  x = data,
  time = time,
  from = 24,
  to = 144,
  min_lum = 200,
  periodogram_length = 48
)
plot(res$curves[,1],res$curves[,2], xlab = "time", ylab = "relative luminescence")
}
