% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcoreset.R
\name{plotcoreset}
\alias{plotcoreset}
\title{Plot core set}
\usage{
plotcoreset(
  v,
  binary = FALSE,
  imputations = TRUE,
  projected = FALSE,
  solutions = NULL,
  allocations = NULL,
  color = "blue"
)
}
\arguments{
\item{v}{A characteristic function, as a vector. The game represented by \code{v} is assumed to be a profit game (i.e., a game in which a greater allocation is a more desirable allocation), not a cost game (i.e., a game in which a smaller allocation is a more desirable allocation).}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{imputations}{A logical value. By default, \code{imputations=TRUE}. When set to \code{imputations=FALSE}, the set of imputations is not drawn.}

\item{projected}{A logical value. By default, \code{projected=FALSE}. When set to \code{projected=TRUE}, for games with three or four players the function draws a projection of the core set (and a projection of the set of imputations, as long as \code{imputations=TRUE}) instead of a full-dimensional representation.}

\item{solutions}{Optional. A character vector containing a solution or a series of solutions to be added to the plot. Valid solutions:
\code{"corecenter"}, \code{"nucleolus"}, \code{"nucleoluspc"}, \code{"shapleyvalue"}, \code{"tauvalue"}.}

\item{allocations}{Optional. A matrix containing an allocation or a series of allocations to be added to the plot. The matrix should have as many columns as players in \code{v} and as many rows as allocations are introduced, so that each row contains an allocation.}

\item{color}{The color in which the core set is to be drawn. By default, \code{color="blue"}.}
}
\value{
A core set plot with the specified features.
}
\description{
Given a game with two, three or four players, this function plots its core set and set of imputations.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\examples{
v1 <- claimsgame(E=8,d=c(3,5,6))
plotcoreset(v1,solutions=c("nucleolus","shapleyvalue"))

v2 <- c(0,0,0,0,0,0,0,0,1,4,1,3,6,8,10)
plotcoreset(v2,solutions=c("corecenter","nucleoluspc"))
}
\seealso{
\link{plotcoresets}
}
