% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dualgame.R
\name{dualgame}
\alias{dualgame}
\title{Dual game}
\usage{
dualgame(v)
}
\arguments{
\item{v}{A characteristic function, as a vector.}
}
\value{
The characteristic function of the dual game. It is to be interpreted according to the order that \code{v} is introduced in.
}
\description{
Given the characteristic function of a game, this function returns the characteristic function of the dual game.
}
\details{
The dual game of \eqn{v\in G^N} is defined by \eqn{v^D(S)=v(N)-v(N\backslash S)} for all \eqn{S \in 2^N}.
}
\examples{
v <- c(rep(0,4),rep(5,6),rep(20,4),40)
dualgame(v)
v <- seq(1:31)
dualgame(v)
dualgame(dualgame(v)) == v
}
