ind_test_perm <- function(X, n.perm = 200, score = "Identity", weight = "Gauss", ncores = NULL, iseed = NULL) {
  # Match arguments and allow partial matching
  score <- match.arg(score, c("Identity", "Ranks", "VDW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  
  # Construct a key to use in the switch statement
  func_key <- paste(score, weight, sep = "_")
  
  # Use switch to select the appropriate function
  result <- switch(func_key,
                   "Identity_Gauss" = ICAtestGauss_S_perm_par(X, n.perm, ncores, iseed),
                   "Identity_Laplace" = ICAtestLap_S_perm_par(X, n.perm, ncores, iseed),
                   "Ranks_Laplace" = ICAtestRankLap_S_perm_par(X, n.perm, ncores, iseed),
                   "Ranks_Gauss" = ICAtestRankGauss_S_perm_par(X, n.perm, ncores, iseed),
                   "VDW_Gauss" = ICAtestRankvdW_S_perm_par(X, n.perm, ncores, iseed)
  )
  
  # Append additional information to the result
  result$score <- score
  result$weight <- weight
  
  return(result)
}
