icm_test_perm <- function(X, n.perm = 200, score = "Identity", weight = "Gauss", 
                          ica = "JADE", ncores = NULL, iseed = NULL, eps = 1e-06, 
                          maxiter = 100, g = "tanh", method = "sym", inR = FALSE, n.init = 2) {
  
  # Match arguments 
  score <- match.arg(score, c("Identity", "Rank", "VdW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  ica <- match.arg(ica, c("JADE", "FOBI", "fICA"))
  
  # Create a unique method name based on inputs
  method <- paste0("ICAtest", score, weight, ica, "_perm_par")
  
  # Switch to select the appropriate function and execute it
  res <- switch(method,
                ICAtestIdentityGaussJADE_perm_par = ICAtestGauss_jade_perm_par(X, n.perm, eps, maxiter, ncores, iseed),
                ICAtestIdentityGaussFOBI_perm_par = ICAtestGauss_fobi_perm_par(X, n.perm, ncores, iseed),
                ICAtestIdentityGaussfICA_perm_par = ICAtestGauss_fICA_perm_par(X, n.perm, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestIdentityLaplaceJADE_perm_par = ICAtestLap_jade_perm_par(X, n.perm, eps, maxiter, ncores, iseed),
                ICAtestIdentityLaplaceFOBI_perm_par = ICAtestLap_fobi_perm_par(X, n.perm, ncores, iseed),
                ICAtestIdentityLaplacefICA_perm_par = ICAtestLap_fICA_perm_par(X, n.perm, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestRankGaussJADE_perm_par = ICAtestRankGauss_jade_perm_par(X, n.perm, eps, maxiter, ncores, iseed),
                ICAtestRankGaussFOBI_perm_par = ICAtestRankGauss_fobi_perm_par(X, n.perm, ncores, iseed),
                ICAtestRankGaussfICA_perm_par = ICAtestRankGauss_fICA_perm_par(X, n.perm, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestRankLaplaceJADE_perm_par = ICAtestRankLap_jade_perm_par(X, n.perm, eps, maxiter, ncores, iseed),
                ICAtestRankLaplaceFOBI_perm_par = ICAtestRankLap_fobi_perm_par(X, n.perm, ncores, iseed),
                ICAtestRankLaplacefICA_perm_par = ICAtestRankLap_fICA_perm_par(X, n.perm, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                ICAtestVdWGaussJADE_perm_par = ICAtestRankvdW_jade_perm_par(X, n.perm, eps, maxiter, ncores, iseed),
                ICAtestVdWGaussFOBI_perm_par = ICAtestRankvdW_fobi_perm_par(X, n.perm, ncores, iseed),
                ICAtestVdWGaussfICA_perm_par = ICAtestRankvdW_fICA_perm_par(X, n.perm, g, method, inR, maxiter, eps, n.init, ncores, iseed),
                stop("Unsupported method combination"))
  
  # Add the score and weight information to the result list
  res$score <- score
  res$weight <- weight
  res$ica <- ica
  
  return(res)
}
