% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source.taf.R
\name{source.taf}
\alias{source.taf}
\alias{sourceTAF}
\title{Run TAF Script}
\usage{
source.taf(script, rm = FALSE, clean = TRUE, detach = FALSE,
  taf = NULL, quiet = FALSE)
}
\arguments{
\item{script}{script filename.}

\item{rm}{whether to remove all objects from the global environment before
and after the script is run.}

\item{clean}{whether to \code{\link{clean}} the target directory before
running the script.}

\item{detach}{whether to detach all non-base packages before running the
script, to ensure that the script is not affected by packages that may
have been attached outside the script.}

\item{taf}{a convenience flag where \code{taf = TRUE} sets \code{rm},
\code{clean}, and \code{detach} to \code{TRUE}, as is done on the TAF
server. Any other value of \code{taf} is ignored.}

\item{quiet}{whether to suppress messages reporting progress.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the script ran without
errors.
}
\description{
Run a TAF script and return to the original directory.
}
\details{
The default value of \code{rm = FALSE} is to protect users from accidental
loss of work, but the TAF server always runs with \code{rm = TRUE} to make
sure that only files, not objects in memory, are carried over between
scripts.

Likewise, the TAF server runs with \code{clean = TRUE} to make sure that the
script starts with a clean directory. The target directory of a TAF script
has the same filename prefix as the script: \verb{data.R} creates \file{data}
etc.
}
\note{
Commands within a script (such as \code{setwd}) may change the working
directory, but \code{source.taf} guarantees that the working directory
reported by \code{getwd()} is the same before and after running a script.
}
\examples{
\dontrun{
write("print(pi)", "script.R")
source("script.R")
source.taf("script.R")
file.remove("script.R")
}

}
\seealso{
\code{\link{source}} is the base function to run R scripts.

\code{\link{make.taf}} runs a TAF script if needed.

\code{\link{source.all}} runs all TAF scripts in a directory.

\code{\link{TAF-package}} gives an overview of the package.
}
