% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{segements_df}
\alias{segements_df}
\title{Shorten and offset the segment}
\usage{
segements_df(data, shorten_start, shorten_end, offset)
}
\arguments{
\item{data}{A data frame containing the segments.
It should have columns 'x', 'y', 'xend', and 'yend' representing the start and end points of each segment.}

\item{shorten_start}{The amount to shorten the start of each segment by.}

\item{shorten_end}{The amount to shorten the end of each segment by.}

\item{offset}{The amount to offset each segment by.}
}
\value{
The modified data frame with the shortened and offset segments.
}
\description{
This function takes a data frame representing segments in a plot and shortens
and offsets them based on the provided arguments.
}
\examples{
library(ggplot2)
temp_nodes <- data.frame(
  "x" = c(10, 40),
  "y" = c(10, 30)
)
data <- data.frame(
  "x" = c(10, 40),
  "y" = c(10, 30),
  "xend" = c(40, 10),
  "yend" = c(30, 10)
)

ggplot(temp_nodes, aes(x = x, y = y)) +
  geom_point(size = 12) +
  xlim(0, 50) +
  ylim(0, 50) +
  geom_segment(
    data = data,
    aes(x = x, xend = xend, y = y, yend = yend)
  )

ggplot(temp_nodes, aes(x = x, y = y)) +
  geom_point(size = 12) +
  xlim(0, 50) +
  ylim(0, 50) +
  geom_segment(
    data = segements_df(
      data,
      shorten_start = 2,
      shorten_end = 3,
      offset = 1
    ),
    aes(x = x, xend = xend, y = y, yend = yend)
  )
}
