% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_xml2txt.R
\name{convert_xml2txt}
\alias{convert_xml2txt}
\title{Transforming a STICS xml file into a text file}
\usage{
convert_xml2txt(
  file,
  plant_id = 1,
  soil_name = NULL,
  out_dir = NULL,
  save_as = NULL,
  stics_version = "latest",
  xml_file = lifecycle::deprecated(),
  plt_num = lifecycle::deprecated(),
  out_file = lifecycle::deprecated()
)
}
\arguments{
\item{file}{Path (including name) of the xml file to convert}

\item{plant_id}{The plant identifier (main crop: 1 ; associated crop: 2)}

\item{soil_name}{Soil name (optional, required for soil file)}

\item{out_dir}{Path of the directory where to generate the file.
Optional, set to the path of the input xml file by default}

\item{save_as}{Name of the output file
(optional, default: fixed name for STICS)}

\item{stics_version}{the STICS files version to use (optional,
default to latest).}

\item{xml_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{xml_file} is no
longer supported, use \code{file} instead.}

\item{plt_num}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{plt_num} is no
longer supported, use \code{plant_id} instead.}

\item{out_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{out_file} is no
longer supported, use \code{save_as} instead.}
}
\value{
None
}
\description{
The input file according to his type
(ini,plant,tec,station,soil,par)
is converted to a text file readable by the STICS model
(ficini.txt, ficplt1.txt,...)
}
\examples{
\dontrun{
xml_path <- "/path/to/corn_plt.xml"
javastics_path <- "/path/to/JavaSTICS/folder"
convert_xml2txt(file = xml_path, javastics = javastics_path)
}

}
