% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_era5_tm.R
\name{get_era5_tme}
\alias{get_era5_tme}
\title{Extract temperature data from ERA5 NetCDF file}
\usage{
get_era5_tme(data, nc_file)
}
\arguments{
\item{data}{A \verb{data frame} containing species records. Must include \code{lon}, \code{lat}, \code{year}, and \code{month} columns.}

\item{nc_file}{Full \code{character} path to the downloaded ERA5-Land raster (\code{.nc}) file.}
}
\value{
The input data frame \code{data} with a new column named (\code{tme}), containing the temperature values.
}
\description{
This function retrieves mean monthly air temperature values associated with species occurrence records based on their geographic coordinates (\code{lon/lat}) and sampling date (\code{year/month}).
}
