% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_comparison.R
\name{sm_compare_models}
\alias{sm_compare_models}
\title{Compare Multiple Topic Models}
\usage{
sm_compare_models(
  dtm,
  k = 10,
  metadata = NULL,
  prevalence = NULL,
  seed = 1729,
  lda_method = "gibbs",
  verbose = TRUE
)
}
\arguments{
\item{dtm}{A DocumentTermMatrix object.}

\item{k}{Number of topics to extract. Default is 10.}

\item{metadata}{Optional data frame with document-level covariates for STM.
Must have the same number of rows as dtm. Default is NULL.}

\item{prevalence}{Optional formula for STM prevalence specification.
Default is NULL.}

\item{seed}{Random seed for reproducibility. Default is 1729.}

\item{lda_method}{Method for LDA. Options: "gibbs" or "vem".
Default is "gibbs".}

\item{verbose}{Logical indicating whether to print progress messages.
Default is TRUE.}
}
\value{
A list containing:
  \item{models}{List of fitted models (lda, stm, ctm)}
  \item{metrics}{Data frame comparing coherence and exclusivity}
  \item{recommendation}{Character string naming the optimal model}
}
\description{
Trains and compares three topic modeling approaches: LDA (Latent Dirichlet
Allocation), STM (Structural Topic Model), and CTM (Correlated Topic Model).
Calculates semantic coherence and exclusivity metrics for each model and
suggests the optimal model.
}
\examples{
\dontrun{
# Requires document-term matrix from sm_create_dtm()
dtm <- sm_create_dtm(processed_data)
comparison <- sm_compare_models(dtm, k = 10)
print(comparison$metrics)
print(comparison$recommendation)
}
}
