% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{parent_level}
\alias{parent_level}
\alias{child_level}
\title{Parent/Child Hierarchy}
\usage{
parent_level(level, n = 1)

child_level(level, n = 1)
}
\arguments{
\item{level}{character. Initial level name of a taxon. Vectors include values that are one of: \code{"order"}, \code{"suborder"}, \code{"greatgroup"}, \code{"subgroup"}, \code{"family"}}

\item{n}{Number of levels above/below (parent/child). Default: \code{1}}
}
\value{
character. Level name of parent or child at specified level above input \code{level}.
}
\description{
Parent/Child Hierarchy
}
\examples{
parent_level('subgroup')

child_level('greatgroup')

parent_level('family', 3)

# no level above order
parent_level('family', 5)
}
