% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon_index.R
\name{shannon_index}
\alias{shannon_index}
\title{Calculate Shannon Index for diversity}
\usage{
shannon_index(var_tibble)
}
\arguments{
\item{var_tibble}{a tibble with two columns (name of species, count per species),
the second column must be called "count"}
}
\value{
double of the Shannon Index
}
\description{
This function calculates the Index of Shannon (1948)
for a tibble with different species.

The formula that is used is
\deqn{SI = -\sum_{i=1}^S (p_i * ln(p_i))}
where \eqn{p_i} is the relative abundance of each species (\eqn{i}) of
the total number of species (\eqn{S}).
}
\examples{
#create tibble
tibble_example <- tibble::tibble(Plant = c("A","B","C","D","E"), count = c(10,5,8,20,10))

#calculate Shannon Index
shannon_index(tibble_example)  # = 1.505...

}
\references{
\insertRef{shannon1948}{SoilManageR}

\insertRef{spellerberg2003tribute}{SoilManageR}
}
\seealso{
\code{\link[=plant_diversity]{plant_diversity()}} to calculate the \code{\link[=shannon_index]{shannon_index()}}
(and other diversity indices) for a management_df
}
