% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/management_df_from_excel.R
\name{management_df_from_excel}
\alias{management_df_from_excel}
\title{Import management_df from excel file}
\usage{
management_df_from_excel(
  path_to_xlsx,
  var_sheet = "Management_template",
  overwrite_year = TRUE
)
}
\arguments{
\item{path_to_xlsx}{path to the excel file with the management data}

\item{var_sheet}{name of the sheet with the management data template in
the excel sheet, default is "Management_template"}

\item{overwrite_year}{logical: if TRUE (default), the \emph{year} will be set to
the year extracted from the \emph{date}}
}
\value{
a management_df
}
\description{
This function imports management data from an excel template and
transforms it into a \link{management_df}.
Additionaly, it checks if all columns
that are expected for a managment_df are available.
The excel template can be found in the SoilManageR Package under
inst/extdata/SoilManageR_mgmt_data_template. Optionaly, the parameter
\emph{year} can be overwritten by the year extracted from \emph{date}.
}
\examples{
#create path
path_to_xlsx_template <- system.file(
"/extdata/SoilManageR_mgmt_data_template_V2.6.xlsx", package = "SoilManageR")

#load management_df
management_df_from_excel(path_to_xlsx_template)
}
\seealso{
\itemize{
\item \code{\link[=management_df]{management_df()}} for creating an management_df
\item \code{\link[=check_management_df]{check_management_df()}} to check the integrity of a management_df
}
}
