% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_C_input_tibble.R
\name{calculate_C_input_tibble}
\alias{calculate_C_input_tibble}
\title{Calculate C input tibble}
\usage{
calculate_C_input_tibble(var_MGMT_data)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}
}
\value{
tibble with C input values
}
\description{
A function that calculates the C input by crops, cover crops and organic amendments.
The output is returned as a tibble.
}
\details{
The function is mainly a helper function for the \code{\link[=C_input]{C_input()}} function.
}
\examples{
#Calculate C input tibble
calculate_C_input_tibble(EXAMPLE_data)
}
\seealso{
\itemize{
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=C_input_crops]{C_input_crops()}} to calculate C input for crops
\item \code{\link[=C_input_cover_crops]{C_input_cover_crops()}} to calculate C input for cover crops
\item \code{\link[=CN_input_amendments]{CN_input_amendments()}} to calculate C (and N) inputs for organic amendments
\item \code{\link[=C_input]{C_input()}} a function that calculates the N input by mineral and organic fertilization and summarizes it by year
}
}
