% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability_indices.R
\name{sobol_reliability}
\alias{sobol_reliability}
\title{Reliability-Oriented Sobol Indices}
\usage{
sobol_reliability(result, threshold, less = TRUE)
}
\arguments{
\item{result}{Output of \code{\link[=sobol_indices]{sobol_indices()}} computed with
\code{keep_samples = TRUE}.}

\item{threshold}{Numeric scalar defining the failure boundary.}

\item{less}{Logical, when \code{TRUE} failures correspond to
\code{response <= threshold}; otherwise, failures correspond to
\code{response >= threshold}.}
}
\value{
A \code{sobol_result} instance storing the Sobol indices of the failure
indicator along with the estimated failure probability and its variance.
}
\description{
Transform stored simulator samples into Sobol indices for the binary failure
indicator described by Lebrun et al. (2021). The function reuses the
Saltelli-type estimator from \code{\link[=sobol_indices]{sobol_indices()}} and therefore requires a
previous call with \code{keep_samples = TRUE}.
}
\examples{
design <- sobol_design(n = 128, d = 3, lower = rep(-pi, 3), upper = rep(pi, 3))
stochastic <- sobol_indices(ishigami_model, design, replicates = 3,
                            keep_samples = TRUE)
failure <- sobol_reliability(stochastic, threshold = -1)
Sobol4R::autoplot(failure, show_uncertainty = TRUE)
}
