% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example2.R
\name{sobol_example_random_output}
\alias{sobol_example_random_output}
\title{Example 2: Random effect on the output (constant Gaussian noise)}
\usage{
sobol_example_random_output(
  n = 50000,
  sd = 1,
  nrep_qoi = 1000,
  order = 2,
  nboot = 100
)
}
\arguments{
\item{n}{Monte Carlo sample size for each base design.}

\item{sd}{Standard deviation of the Gaussian noise.}

\item{nrep_qoi}{Number of repetitions for the QoI.}

\item{order}{Maximum interaction order.}

\item{nboot}{Number of bootstrap replicates.}
}
\value{
A list with three \code{"sobol"} objects:
\code{x_det} (deterministic G-function),
\code{x_noise} (single noisy output),
\code{x_qoi} (QoI-based indices).
}
\description{
Two inputs in [0, 1], Sobol G-function with k = 2, plus additive
Gaussian noise, and a QoI based on the mean of repeated evaluations.
}
