% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_qoi_indices.R
\name{sobol4r_qoi_indices}
\alias{sobol4r_qoi_indices}
\title{Generic QoI-based Sobol indices for a stochastic model}
\usage{
sobol4r_qoi_indices(
  model,
  X1,
  X2,
  qoi_fun = base::mean,
  nrep = 1000,
  order = 2,
  nboot = 0,
  type = c("soboljansen", "sobol", "sobol2007", "sobolEff", "sobolmartinez"),
  ...
)
}
\arguments{
\item{model}{Stochastic model function that takes a matrix or data.frame
\code{X} and returns a numeric vector of length \code{nrow(X)}.}

\item{X1, X2}{Two base designs (matrices or data.frames).}

\item{qoi_fun}{Function used to summarize the repetitions
(default is \code{mean}).}

\item{nrep}{Number of repetitions of the stochastic model for each
design point.}

\item{order}{Maximum interaction order (1 or 2).}

\item{nboot}{Number of bootstrap replicates for Sobol indices.}

\item{type}{Which estimator to use. Any \pkg{sensitivity} Sobol helper is
supported: \code{"sobol"}, \code{"sobol2007"}, \code{"soboljansen"},
\code{"sobolEff"}, or \code{"sobolmartinez"}. Defaults to
\code{"soboljansen"}, the most robust general-purpose choice.}

\item{...}{Additional arguments passed to \code{model}.}
}
\value{
An object of class \code{"sobol"} with QoI-based Sobol indices.
}
\description{
This function extends the classical Sobol indices to a stochastic
simulator by first computing a quantity of interest (QoI) for each
input point, such as the mean of repeated runs.
}
