% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probability_parameter.R
\name{Parameter_Calculate}
\alias{Parameter_Calculate}
\title{Adaptive Parameter Tuning for Single-Cell Data Annotation in SlimR}
\usage{
Parameter_Calculate(
  seurat_obj,
  features = NULL,
  assay = NULL,
  cluster_col = NULL,
  n_celltypes = 50,
  verbose = TRUE
)
}
\arguments{
\item{seurat_obj}{A Seurat object containing single-cell data}

\item{features}{Character vector of feature names (genes) to analyze. If NULL,
will use highly variable features from the Seurat object.}

\item{assay}{Name of assay to use (default: default assay)}

\item{cluster_col}{Column name in metadata containing cluster information}

\item{n_celltypes}{Expected number of cell types in marker database (default: 50).
Used for threshold recommendation calculation.}

\item{verbose}{Whether to print progress messages (default: TRUE)}
}
\value{
A list containing:
\itemize{
\item min_expression: Recommended expression threshold
\item specificity_weight: Recommended specificity weight
\item threshold: Recommended probability threshold for candidate selection
\item dataset_features: Extracted dataset characteristics
\item parameter_rationale: Explanation of parameter choices
}
}
\description{
This function automatically determines optimal min_expression, specificity_weight,
and threshold parameters for single-cell data analysis based on dataset characteristics
using adaptive algorithms derived from empirical analysis of single-cell datasets.
}
\examples{
\dontrun{
SlimR_params <- Parameter_Calculate(
  seurat_obj = sce,
  features = c("CD3E", "CD4", "CD8A"),
  assay = "RNA",
  cluster_col = "seurat_clusters",
  n_celltypes = 98,
  verbose = TRUE
  )
}

}
\seealso{
Other Section_3_Automated_Annotation: 
\code{\link{Celltype_Annotation}()},
\code{\link{Celltype_Annotation_PerCell}()},
\code{\link{Celltype_Calculate}()},
\code{\link{Celltype_Calculate_PerCell}()},
\code{\link{Celltype_Verification}()},
\code{\link{Celltype_Verification_PerCell}()},
\code{\link{percell_workflow}}
}
\concept{Section_3_Automated_Annotation}
